//
//  NSBezierPath+MCAdditions.h
//  MCApplication
//
//  Created by aj on Mon Oct 15 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>


@interface NSBezierPath (MCAdditions) 
+ (NSBezierPath *)roundedRect:(NSRect)aRect radius:(float)radius;

+ (void)fillRoundedRect:(NSRect)aRect radius: (float)radius;
+ (void)strokeRoundedRect:(NSRect)aRect radius: (float)radius;

+ (void)fillTopRoundedRect:(NSRect)aRect radius: (float)radius;
+ (void)strokeTopRoundedRect:(NSRect)aRect radius: (float)radius;

+ (void)fillBottomRoundedRect: (NSRect)aRect radius: (float)radius;
+ (void)strokeBottomRoundedRect: (NSRect)aRect radius: (float)radius;



+ (NSBezierPath *)bezierPathWithDownArrowInRect:(NSRect)r;

+ (NSBezierPath *)bezierPathWithUpArrowInRect:(NSRect)r;

+ (NSBezierPath *)bezierPathWithRightArrowInRect:(NSRect)aRect;

+ (NSBezierPath *)bezierPathWithLeftArrowInRect:(NSRect)aRect;

+ (NSBezierPath *)bezierPathWithOctagonInRect:(NSRect)r;

+ (NSBezierPath *)bezierPathWithDiamondInRect:(NSRect)r;

+ (NSBezierPath *)bezierPathWithCheapCheckmarkInRect:(NSRect)r;

+ (NSBezierPath *)bezierPathWithCheapCheckmarkInFlippedRect:(NSRect)r;


@end
